/**
 * \file: exchnd_interface.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * Header for the user space interface to the exception handler device.
 *
 * \component: exchndd
 *
 * \author: Kai Tomerius (ktomerius@de.adit-jv.com)
 *
 * \copyright (c) 2013 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 * \see <related items>
 *
 * \history
 *
 ***********************************************************************/

#ifndef __EXCHND_INTERFACE_H__
#define __EXCHND_INTERFACE_H__

#include <linux/exchnd.h>

/* Check driver version */
int exchnd_check_version(int, char *);

/* Open and check device */
int exchnd_create_device(char *dev_name, int flags);

/* trigger read pointer recovery */
int exchnd_recover(int);

/* Configure modules gathering */
int exchnd_configure_module(int, struct exchnd_conf_param);

/* exchnd_print_triggers - print the list of available triggers */
extern void exchnd_print_triggers(void);

/* exchnd_print_modules - print get the list of available modules */
extern void exchnd_print_modules(void);

/* exchnd_print_signals - print get the list of available signals */
extern void exchnd_print_signals(void);

/* exchnd_print_configuration - print the configuration of a trigger */
void exchnd_print_configuration(int exh_fd, struct exchnd_conf_param conf);

/* exchnd_configuration_set - set the configuration for a trigger */
void exchnd_configuration_set(int exh_fd, struct exchnd_conf_param conf);

/* exchnd_print_def_conf - print a default trigger's configuration */
void exchnd_print_def_conf(int exh_fd, struct exchnd_conf_param conf);

/* exchnd_def_conf_set - select the  default trigger's configuration */
void exchnd_def_conf_set(int exh_fd, struct exchnd_conf_param conf);

/* exchnd_modify_filter - modify filter white list */
#define UPROCESS 0x0
#define KPROCESS 0x1
#define ADD_PROCESS 0x2
#define MAX_NUM_PROCESS 100
#define PROCESS_NAME_MAX_LENGTH 255
void exchnd_modify_filter(int exh_fd, struct exchnd_conf_filter conf);

/* exchnd_config_app_specific - modify application specific configuration */
void exchnd_config_app_specific(int, enum exchnd_modules, char *);

/* exchnd_destroy - de-initialize the error memory interface */
void exchnd_destroy(int exh_fd);

/* exchnd_normalize - Normalize strings. */
void exchnd_normalize(char *to_norm);

#endif /* __EXCHND_INTERFACE_H__ */